@extends('layouts.app')

@section('content')
<div class="container">
    <h1>Create Product</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('products.store') }}" method="POST">
        @csrf

        <div class="mb-3">
            <label for="name" class="form-label">Product Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ old('name') }}" required>
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description" rows="3" required>{{ old('description') }}</textarea>
        </div>

        <div class="mb-3">
            <label for="sku" class="form-label">SKU</label>
            <input type="text" class="form-control" id="sku" name="sku" value="{{ old('sku') }}" required>
        </div>

        <div class="mb-3">
            <label for="category_id" class="form-label">Category</label>
            <select class="form-select" id="category_id" name="category_id" required>
                <option value="" disabled selected>Select a category</option>
                @foreach ($categories as $category)
                    <option value="{{ $category->id }}" {{ old('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="use_by_date" class="form-label">Use By Date</label>
            <input type="date" class="form-control" id="use_by_date" name="use_by_date" value="{{ old('use_by_date') }}" required>
        </div>

        <div class="mb-3">
            <label for="wholesale_price" class="form-label">Wholesale Price</label>
            <input type="number" step="0.01" class="form-control" id="wholesale_price" name="wholesale_price" value="{{ old('wholesale_price') }}" required>
        </div>

        <div class="mb-3">
            <label for="minimum_order_quantity" class="form-label">Minimum Order Quantity</label>
            <input type="number" class="form-control" id="minimum_order_quantity" name="minimum_order_quantity" value="{{ old('minimum_order_quantity') }}" required>
        </div>

        <div class="mb-3">
            <label for="available_quantity" class="form-label">Available Quantity</label>
            <input type="number" class="form-control" id="available_quantity" name="available_quantity" value="{{ old('available_quantity') }}" required>
        </div>

        <button type="submit" class="btn btn-primary">Create Product</button>
    </form>
</div>
@endsection